
# Read data - Please modify the path to correctly import the file
df <- read.csv("D:user10_evenline_nonconformity.csv")

n <- nrow(df)

user <- 10


# Parameter settings

set.seed(12345)

r <- 0.9

alpha <- 0.1


# Define LRBR function

LRBR <- function(S, q, r) {
  
  u <- rbinom(1, 1, r)
  
  v <- rbinom(1, 1, 0.5)
  
  if (u == 1) {
    
    return(as.numeric(q > S))  # Equivalent to S <= q
    
  } else {
    
    return(v)
    
  }
  
}


set_size <- numeric(n)


# Initialize variables

cover_vec <- numeric(n)

W <- numeric(n)

s <- numeric(n + 1)

g_t <- numeric(n)

lambda <- numeric(n + 1)

lambda[1] <- 0

s[1] <- 0



# Main loop

for (i in 1:n) {
  
  y_true <- df$true_class[i]
  
  S_t <- c(
    
    df$nonconf_score_class_0[i],
    
    df$nonconf_score_class_1[i],
    
    df$nonconf_score_class_2[i],
    
    df$nonconf_score_class_3[i],
    
    df$nonconf_score_class_4[i]
    
  )
  
  S_true_current <- S_t[y_true + 1]
  
  
  
  # Record coverage status
  
  cover_vec[i] <- as.numeric(s[i] > S_true_current)
  
  set_size[i] <- sum(S_t <= s[i])
  
  
  
  L <- LRBR(S_true_current, s[i], r)
  
  
  
  # Compute gradient
  
  if (L == 1) {
    
    g_t[i] <- 1 - (r*(1-alpha) + (1-r)*0.5)
    
  } else {
    
    g_t[i] <- -(r*(1-alpha) + (1-r)*0.5)
    
  }
  
  
  
  # Update W and lambda
  
  if (i == 1) {
    
    W[i] <- 1 - g_t[i] * s[1]
    
  } else {
    
    W[i] <- W[i-1] - g_t[i] * s[i]
    
  }
  
  lambda[i+1] <- (i / (i+1)) * lambda[i] - (1 / (i+1)) * g_t[i]
  
  s[i+1] <- lambda[i+1] * W[i]
  
}



# Calculate coverage metrics

rolling_window <- 200

rolling_coverage <- rep(NA, n)

longrun_coverage <- numeric(n)

cumulative_cover <- cumsum(cover_vec)


for (i in 1:n) {
  
  longrun_coverage[i] <- cumulative_cover[i] / i
  
  if (i >= rolling_window) {
    
    rolling_coverage[i] <- mean(cover_vec[(i - rolling_window + 1):i])
    
  }
  
}


rolling_setsize <- rep(NA, n)

longrun_setsize <- numeric(n)

cumulative_size <- cumsum(set_size)


for (i in 1:n) {
  
  longrun_setsize[i] <- cumulative_size[i] / i
  
  if (i >= rolling_window) {
    
    rolling_setsize[i] <- mean(set_size[(i - rolling_window + 1):i])
    
  }
  
}


# Create data frame for results

result_df <- data.frame(
  
  timestep = 1:n,
  
  s_t = s[1:n],
  
  covered = cover_vec,
  
  set_size = set_size,
  
  rolling_coverage = rolling_coverage,
  
  longrun_coverage = longrun_coverage,
  
  rolling_setsize = rolling_setsize,
  
  longrun_setsize = longrun_setsize
  
)



colnames(result_df) <- c(
  
  "timestep",
  
  "s_t",
  
  "covered",
  
  "set_size",
  
  "rolling_coverage",
  
  "longrun_coverage",
  
  "rolling_setsize",
  
  "longrun_setsize"
  
)



# Generate output file name with timestamp

timestamp <- format(Sys.time(), "%Y%m%d_%H%M%S")

filename <- paste0("WISDM_r", r, "_user", user, "_", timestamp, ".csv")


# Save the result - Modify the save path as needed

write.csv(
  
  result_df,
  
  paste0("D:/", filename),
  
  row.names = FALSE
  
)



cat("✅ Result saved to: ", filename, "\n")
